<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Shopify API Version
    |--------------------------------------------------------------------------
    |
    | The Shopify API version to use for all requests.
    |
    */
    'api_version' => env('SHOPIFY_API_VERSION', '2024-01'),

    /*
    |--------------------------------------------------------------------------
    | Sync Settings
    |--------------------------------------------------------------------------
    |
    | Configure how often data should be synced from Shopify.
    |
    */
    'sync' => [
        'products' => [
            'enabled' => true,
            'interval_minutes' => 60, // Sync products every hour
            'limit_per_request' => 250,
        ],
        'orders' => [
            'enabled' => true,
            'interval_minutes' => 15, // Sync orders every 15 minutes
            'limit_per_request' => 250,
            'sync_days_back' => 30, // Only sync orders from last 30 days on initial sync
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Analytics Settings
    |--------------------------------------------------------------------------
    |
    | Configure analytics and reporting features.
    |
    */
    'analytics' => [
        'low_stock_threshold' => 10,
        'top_products_limit' => 10,
        'revenue_trend_days' => 30,
    ],

    /*
    |--------------------------------------------------------------------------
    | Automation Settings
    |--------------------------------------------------------------------------
    |
    | Configure automated marketing features.
    |
    */
    'automation' => [
        'abandoned_cart' => [
            'enabled' => true,
            'delay_hours' => 2, // Wait 2 hours before sending recovery message
            'max_attempts' => 3,
        ],
        'low_stock_alert' => [
            'enabled' => true,
            'threshold' => 10,
        ],
        'new_product_announcement' => [
            'enabled' => true,
            'auto_send' => false, // Require manual approval
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | UTM Tracking
    |--------------------------------------------------------------------------
    |
    | Default UTM parameters for campaign tracking.
    |
    */
    'utm' => [
        'source' => 'marketing_bot',
        'medium' => 'message',
    ],
];
